	
 
; Turntable Strobe
; run with MPLAB SIM for 10.000ms period for 100Hz strobe and 8.333ms period for 120Hz strobe
; assuming 4MHz crystal (1us per instruction)
; 1ms LED pulse or 2ms LED pulse 

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _XT_OSC	

; RAM 

STORE1			equ	H'20'	; delay register
STORE2			equ	H'21'	; delay register
STORE3			equ	H'22'	; for 120Hz 

; ******************************************************************

; start at memory 0

	org	4				; 

MAIN
	bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
	clrf		GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0; select memory bank 1
	clrf		ANSEL		; digital I/O
	movlw	B'00000000'	; settings (pullups enabled) 
	movwf	OPTION_REG
	movlw	B'00101110'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'00000110'	; GP1,GP2 pullup 
	movwf	WPU

	bcf		STATUS,RP0	; select memory bank 0

	movlw	D'3'
	movwf	STORE3		; set at 3

; OPTIONAL 1ms or 2ms LED pulse 

	btfss	GPIO,1		; if high 1ms
	goto	TWOms		; LED drive for 2ms


ONEms	; 1ms pulse
; initial condition
	clrf	GPIO

; if GP2 low, change mode to 120Hz
SELECT
	btfss	GPIO,2
	goto	ONE_TWO_0_Hz

ONE_0_0Hz
;100Hz
	bsf		GPIO,0

;  delay on time 
	movlw	D'40'		; delay extension
	movwf 	STORE2
DEL1
	movlw	D'7'		; delay routine
	movwf	STORE1	
DEL_CONT1
	decfsz	STORE1,f	; when 0, exit delay
	goto	DEL_CONT1
	decfsz	STORE2,f
	goto	DEL1	

	bcf		GPIO,0
;  delay off time 
	movlw	D'57'
	movwf	STORE2
DELAY_SHORT1
	decfsz	STORE2,f
	goto	DELAY_SHORT1
	movlw	D'45'		; delay extension
	movwf 	STORE2
DEL2
	movlw	D'64'		; delay routine
	movwf	STORE1	
DEL_CONT2
	decfsz	STORE1,f	; when 0, exit delay
	goto	DEL_CONT2
	decfsz	STORE2,f
	goto	DEL2	
	goto	SELECT


ONE_TWO_0_Hz
;120Hz
	bsf		GPIO,0

;  delay on time 
	movlw	D'40'		; delay extension
	movwf 	STORE2
DEL3
	movlw	D'7'		; delay routine
	movwf	STORE1	
DEL_CONT3
	decfsz	STORE1,f	; when 0, exit delay
	goto	DEL_CONT3
	decfsz	STORE2,f
	goto	DEL3	

	bcf		GPIO,0

; alternate extra cycle every three
	decfsz	STORE3,f
	goto	SKIP1
	movlw	D'3'
	movwf	STORE3
SKIP1	

;  delay off time 
	movlw	D'88'
	movwf	STORE2
DELAY_SHORT2
	decfsz	STORE2,f
	goto	DELAY_SHORT2
	movlw	D'36'		; delay extension
	movwf 	STORE2
DEL4
	movlw	D'64'		; delay routine
	movwf	STORE1	
DEL_CONT4
	decfsz	STORE1,f	; when 0, exit delay
	goto	DEL_CONT4
	decfsz	STORE2,f
	goto	DEL4	
	goto	SELECT


;----------------------------------------------------------------------------------------------------------

TWOms	; 2ms pulse
; initial condition
	clrf	GPIO

; if GP2 low, change mode to 120Hz
SELECT_2
	btfss	GPIO,2
	goto	ONE_TWO_0_Hz_2

ONE_0_0Hz_2
;100Hz
	bsf		GPIO,0

;  delay on time 
	movlw	D'80'		; delay extension
	movwf 	STORE2
DEL1_2
	movlw	D'7'		; delay routine
	movwf	STORE1	
DEL_CONT1_2
	decfsz	STORE1,f	; when 0, exit delay
	goto	DEL_CONT1_2
	decfsz	STORE2,f
	goto	DEL1_2	

	bcf		GPIO,0
	nop
;  delay off time 
	movlw	D'50'
	movwf	STORE2
DELAY_SHORT1_2
	decfsz	STORE2,f
	goto	DELAY_SHORT1_2
	movlw	D'40'		; delay extension
	movwf 	STORE2
DEL2_2
	movlw	D'64'		; delay routine
	movwf	STORE1	
DEL_CONT2_2
	decfsz	STORE1,f	; when 0, exit delay
	goto	DEL_CONT2_2
	decfsz	STORE2,f
	goto	DEL2_2	
	goto	SELECT_2


ONE_TWO_0_Hz_2
;120Hz
	bsf		GPIO,0

;  delay on time 
	movlw	D'80'		; delay extension
	movwf 	STORE2
DEL3_2
	movlw	D'7'		; delay routine
	movwf	STORE1	
DEL_CONT3_2
	decfsz	STORE1,f	; when 0, exit delay
	goto	DEL_CONT3_2
	decfsz	STORE2,f
	goto	DEL3_2	

	bcf		GPIO,0
	nop

; alternate extra cycle every three
	decfsz	STORE3,f
	goto	SKIP2
	movlw	D'3'
	movwf	STORE3
SKIP2

;  delay off time 
	movlw	D'81'
	movwf	STORE2
DELAY_SHORT2_2
	decfsz	STORE2,f
	goto	DELAY_SHORT2_2
	movlw	D'31'		; delay extension
	movwf 	STORE2
DEL4_2
	movlw	D'64'		; delay routine
	movwf	STORE1	
DEL_CONT4_2
	decfsz	STORE1,f	; when 0, exit delay
	goto	DEL_CONT4_2
	decfsz	STORE2,f
	goto	DEL4_2	
	goto	SELECT_2


	end
